/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 3.0 Edition
 BSD License, Use at your own risk
 */

#import <UIKit/UIKit.h>

@interface UIView (SubviewGeometry)
// Sprawdzenie, czy widok mieści się w widoku nadrzędnym po umieszczeniu go w podanym punkcie środkowym.
- (BOOL) canMoveToCenter: (CGPoint) aCenter inView: (UIView *) aView withInsets: (UIEdgeInsets) insets;
- (BOOL) canMoveToCenter: (CGPoint) aCenter inView: (UIView *) aView withInset: (float) inset;
- (BOOL) canMoveToCenter: (CGPoint) aCenter inView: (UIView *) aView;

// Przesunięcie widoku w ramach widoku nadrzędnego używając procentów, np. 50% poziomo, 60% pionowo.
// Widok na pewno pozostanie w widoku nadrzędnym.
- (CGPoint) centerInView: (UIView *) aView withHorizontalPercent: (float) h withVerticalPercent: (float) v;
- (CGPoint) centerInSuperviewWithHorizontalPercent: (float) h withVerticalPercent: (float) v;

// Przesunięcie do losowo wybranego punktu w widoku nadrzędnym, w którym widok potomny na pewno się zmieści
// lub jeśli zostanie tak ustalone, w zmienionym widoku nadrzędnym.
- (CGPoint) randomCenterInView: (UIView *) aView withInsets: (UIEdgeInsets) insets;
- (CGPoint) randomCenterInView: (UIView *) aView withInset: (float) inset;

// Animacja przejścia do losowo wybranego punktu określonego widoku lub widoku nadrzędnego.
// Widok potomny na pewno pozostanie w ramach widoku nadrzędnego.
- (void) moveToRandomLocationInView: (UIView *) aView animated: (BOOL) animated;
- (void) moveToRandomLocationInSuperviewAnimated: (BOOL) animated;
@end
